@{
    ModuleVersion = '1.0.0'
    GUID = 'd4e5f6a7-b8c9-4d5e-1f2a-3b4c5d6e7f8a'
    Author = 'Seton'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech (seton@farmtowntech.com). All rights reserved.'
    Description = 'Local and network file system data source provider for ITM. Supports local drives and UNC paths.'

    PowerShellVersion = '5.1'
    RootModule = 'ITM.DataSource.FileSystem.psm1'

    FunctionsToExport = @(
        'Get-FileSystemItems'
        'Get-FileSystemContent'
        'Initialize-FileSystemDataSource'
    )

    VariablesToExport = @()
    CmdletsToExport = @()
    AliasesToExport = @()

    RequiredModules = @('ITM.TreeBuilder')

    PrivateData = @{
        PSData = @{
            Tags = @('FileSystem', 'DataSource', 'LocalFiles', 'UNC', 'ITM')
            ProjectUri = 'https://github.com/farmtowntech/ITM'
            ReleaseNotes = 'Initial release - File system support for local and network paths'
        }
    }
}
