#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.DataSource.FileSystem - Local/Network File System Data Source
.DESCRIPTION
    Provides data source integration for local and network file systems.
    Supports both local drives (C:\) and UNC paths (\\server\share\).
    Automatically registers with TreeBuilder when loaded.
.NOTES
    Version: 1.0.0
    Author: Seton (seton@farmtowntech.com)
    Company: Farm Town Tech
    Year: 2025
.EXAMPLE
    Import-Module ITM.DataSource.FileSystem
    Initialize-FileSystemDataSource -AllowedExtensions @('.ps1', '.txt')
#>

# Module-level state
$script:FS_AllowedExtensions = @('.ps1', '.bat', '.cmd', '.exe')
$script:FS_FilterExtensions = $true

# Import functions
. "$PSScriptRoot\Functions\FileSystem-DataSource.ps1"

# Auto-register when module loads (if TreeBuilder is available)
if (Get-Command Register-DataSource -ErrorAction SilentlyContinue) {
    Initialize-FileSystemDataSource
}

# Export public functions
Export-ModuleMember -Function @(
    'Get-FileSystemItems'
    'Get-FileSystemContent'
    'Initialize-FileSystemDataSource'
)
