@{
    ModuleVersion = '1.0.0'
    GUID = 'c3d4e5f6-a7b8-4c5d-0e1f-2a3b4c5d6e7f'
    Author = 'Seton'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech (seton@farmtowntech.com). All rights reserved.'
    Description = 'H5AI web server data source provider for ITM. Parses H5AI HTML to provide file/folder listings.'

    PowerShellVersion = '5.1'
    RootModule = 'ITM.DataSource.H5AI.psm1'

    RequiredAssemblies = @('System.Web')

    FunctionsToExport = @(
        'Get-H5AIItems'
        'Get-H5AIContent'
        'Get-H5AIWebContent'
        'Initialize-H5AIDataSource'
    )

    VariablesToExport = @()
    CmdletsToExport = @()
    AliasesToExport = @()

    RequiredModules = @('ITM.TreeBuilder')

    PrivateData = @{
        PSData = @{
            Tags = @('H5AI', 'DataSource', 'WebServer', 'ITM')
            ProjectUri = 'https://github.com/farmtowntech/ITM'
            ReleaseNotes = 'Initial release - H5AI web server support'
        }
    }
}
