#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.DataSource.H5AI - H5AI Web Server Data Source
.DESCRIPTION
    Provides data source integration for H5AI file servers.
    Automatically registers with TreeBuilder when loaded.
.NOTES
    Version: 1.0.0
    Author: Seton (seton@farmtowntech.com)
    Company: Farm Town Tech
    Year: 2025
.EXAMPLE
    Import-Module ITM.DataSource.H5AI
    Initialize-H5AIDataSource -AllowedExtensions @('.ps1', '.bat', '.exe')
#>

# Module-level state
$script:H5AI_UserAgent = "ITM H5AI DataSource"
$script:H5AI_Timeout = 30000
$script:H5AI_UseAuth = $false
$script:H5AI_Username = ""
$script:H5AI_Password = ""
$script:H5AI_AllowedExtensions = @('.ps1', '.bat', '.cmd', '.exe')
$script:H5AI_FilterExtensions = $true
$script:H5AI_WebCache = @{}

# Import functions
. "$PSScriptRoot\Functions\H5AI-DataSource.ps1"

# Auto-register when module loads (if TreeBuilder is available)
if (Get-Command Register-DataSource -ErrorAction SilentlyContinue) {
    Initialize-H5AIDataSource
}

# Export public functions
Export-ModuleMember -Function @(
    'Get-H5AIItems'
    'Get-H5AIContent'
    'Get-H5AIWebContent'
    'Initialize-H5AIDataSource'
)
