@{
    ModuleVersion = '1.0.0'
    GUID = 'a1b2c3d4-e5f6-47a8-b9c0-d1e2f3a4b5c6'
    Author = 'Seton'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech (seton@farmtowntech.com). All rights reserved.'
    Description = 'Configuration management for ITM. Handles config.json loading, merging, service verification, and WinGet integration.'

    PowerShellVersion = '5.1'
    RootModule = 'ITM.Config.psm1'

    FunctionsToExport = @(
        'Get-GlobalConfig'
        'Get-DirectoryConfig'
        'Merge-ServiceVerificationConfig'
        'Get-ServiceVerificationInfo'
        'Test-WildcardMatch'
        'Add-WinGetNodesToDirectory'
        'Add-ServiceVerificationToNodes'
        'Show-PresetSelectionPopup'
        'Backup-SelectionState'
        'Restore-SelectionState'
        'Clear-AllSelections'
        'Apply-Preset'
        'Find-NodeByRelativePath'
    )

    VariablesToExport = @()
    CmdletsToExport = @()
    AliasesToExport = @()

    RequiredModules = @('ITM.TreeBuilder', 'ITM.TreeUI')

    PrivateData = @{
        PSData = @{
            Tags = @('Configuration', 'Config', 'WinGet', 'ServiceVerification', 'ITM')
            ProjectUri = 'https://github.com/farmtowntech/ITM'
            ReleaseNotes = 'Initial release - Configuration and WinGet integration support'
        }
    }
}
