#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.Config - Configuration Management Module
.DESCRIPTION
    Handles config.json loading, merging, service verification patterns,
    and WinGet integration for ITM tree nodes.
.NOTES
    Version: 1.0.0
    Author: Seton (seton@farmtowntech.com)
    Company: Farm Town Tech
    Year: 2025
.EXAMPLE
    Import-Module ITM.Config
    $config = Get-GlobalConfig -BaseUrl "https://files.derenzyit.com/ITM/"
#>

# Module-level state
$script:configCache = @{}
$script:globalConfig = $null

# Import functions
. "$PSScriptRoot\Functions\Config-Management.ps1"
. "$PSScriptRoot\Functions\WinGet-Integration.ps1"
. "$PSScriptRoot\Functions\Preset-Management.ps1"

# Export public functions
Export-ModuleMember -Function @(
    'Get-GlobalConfig'
    'Get-DirectoryConfig'
    'Merge-ServiceVerificationConfig'
    'Get-ServiceVerificationInfo'
    'Test-WildcardMatch'
    'Add-WinGetNodesToDirectory'
    'Add-ServiceVerificationToNodes'
    'Show-PresetSelectionPopup'
    'Backup-SelectionState'
    'Restore-SelectionState'
    'Clear-AllSelections'
    'Apply-Preset'
    'Find-NodeByRelativePath'
)
