#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.Core - Core Interactive Menu Module
.DESCRIPTION
    Provides the main interactive menu loop and node interaction functions.
    Handles user input, navigation, selection, and preset application.
.NOTES
    Version: 1.0.0
    Author: Seton (seton@farmtowntech.com)
    Company: Farm Town Tech
    Year: 2025
.EXAMPLE
    Import-Module ITM.Core
    Start-InteractiveMenu -Root $rootNode
#>

# Import functions
. "$PSScriptRoot\Functions\Node-Interaction.ps1"
. "$PSScriptRoot\Functions\Interactive-Menu.ps1"

# Export public functions
Export-ModuleMember -Function @(
    'Start-InteractiveMenu'
    'Toggle-NodeExpansion'
    'Toggle-NodeSelection'
    'Set-ChildrenSelection'
    'Get-SelectedScripts'
)
