@{
    ModuleVersion = '1.0.0'
    GUID = 'b2c3d4e5-f6a7-48b9-c0d1-e2f3a4b5c6d7'
    Author = 'Seton'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech (seton@farmtowntech.com). All rights reserved.'
    Description = 'Execution management for ITM. Handles script downloading, installer execution, service verification, and WinGet integration.'

    PowerShellVersion = '5.1'
    RootModule = 'ITM.Execution.psm1'

    FunctionsToExport = @(
        'Download-File'
        'Test-WindowsTerminal'
        'Get-LicensedSoftwareInSelection'
        'Show-LicenseConfirmation'
        'New-ServiceVerificationScript'
        'New-ExecutionScript'
        'Invoke-SelectedScripts'
    )

    VariablesToExport = @()
    CmdletsToExport = @()
    AliasesToExport = @()

    RequiredModules = @('ITM.TreeUI')

    PrivateData = @{
        PSData = @{
            Tags = @('Execution', 'Installer', 'WinGet', 'ServiceVerification', 'ITM')
            ProjectUri = 'https://github.com/farmtowntech/ITM'
            ReleaseNotes = 'Initial release - Script execution and installer management'
        }
    }
}
