#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.Execution - Script and Installer Execution Module
.DESCRIPTION
    Handles downloading, executing, and managing installers.
    Supports WinGet integration, service verification, and licensed software confirmation.
.NOTES
    Version: 1.0.0
    Author: Seton (seton@farmtowntech.com)
    Company: Farm Town Tech
    Year: 2025
.EXAMPLE
    Import-Module ITM.Execution
    Invoke-SelectedScripts -SelectedNodes $selectedNodes
#>

# Import functions
. "$PSScriptRoot\Functions\Script-Execution.ps1"
. "$PSScriptRoot\Functions\Execution-Script-Builder.ps1"
. "$PSScriptRoot\Functions\License-Confirmation.ps1"

# Export public functions
Export-ModuleMember -Function @(
    'Download-File'
    'Test-WindowsTerminal'
    'Get-LicensedSoftwareInSelection'
    'Show-LicenseConfirmation'
    'New-ServiceVerificationScript'
    'New-ExecutionScript'
    'Invoke-SelectedScripts'
)
