@{
    ModuleVersion = '1.0.0'
    GUID = 'b2c3d4e5-f6a7-4b5c-9d0e-1f2a3b4c5d6e'
    Author = 'Farm Town Tech'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech. All rights reserved.'
    Description = 'Data source abstraction layer for ITM. Converts any data source into TreeNode structures. Supports multiple simultaneous data sources.'

    PowerShellVersion = '5.1'
    RootModule = 'ITM.TreeBuilder.psm1'

    FunctionsToExport = @(
        'Register-DataSource'
        'Get-DataSourceForPath'
        'Build-Tree'
        'Expand-TreeNode'
        'Get-ItemContent'
        'Download-ItemToPath'
    )

    VariablesToExport = @('DataSourceRegistry')
    CmdletsToExport = @()
    AliasesToExport = @()

    RequiredModules = @('ITM.TreeUI')

    PrivateData = @{
        PSData = @{
            Tags = @('DataSource', 'Abstraction', 'TreeBuilder', 'Pluggable')
            ProjectUri = 'https://github.com/derenzyit/ITM'
            ReleaseNotes = 'Initial release - Multi-data-source support'
        }
    }
}
