#Requires -Version 5.1

<#
.SYNOPSIS
    ITM.TreeBuilder - Data Source Abstraction Layer
.DESCRIPTION
    Converts data from any registered data source into TreeNode structures.
    Supports multiple simultaneous data sources (H5AI, FileSystem, SMB, etc.)
.NOTES
    Version: 1.0.0
    Author: Farm Town Tech
.EXAMPLE
    # Register data sources
    Import-Module ITM.DataSource.H5AI
    Import-Module ITM.DataSource.FileSystem
    Import-Module ITM.TreeBuilder

    # Build tree from H5AI
    $tree = Build-Tree -RootPath "https://files.example.com/" -RootName "Web Files"

    # Build tree from FileSystem
    $tree2 = Build-Tree -RootPath "C:\Scripts\" -RootName "Local Scripts"

    # TreeBuilder automatically selects the right data source based on path!
#>

# Module-level data source registry
$script:DataSourceRegistry = @{}

# Import functions
. "$PSScriptRoot\Functions\Build-Tree.ps1"

# Export public functions
Export-ModuleMember -Function @(
    'Register-DataSource'
    'Get-DataSourceForPath'
    'Build-Tree'
    'Expand-TreeNode'
    'Get-ItemContent'
    'Download-ItemToPath'
) -Variable @(
    'DataSourceRegistry'
)
