# TreeNode class for ITM.TreeUI module
# Represents a node in the tree structure (file or directory)

class TreeNode {
    [string]$Name
    [string]$Url
    [bool]$IsDirectory
    [bool]$IsExpanded
    [bool]$IsSelected
    [TreeNode[]]$Children
    [TreeNode]$Parent
    [int]$Level
    [string]$LocalPath  # Path where file will be downloaded
    [bool]$IsVirtualWinGet  # True if this is a WinGet node (parent or child)
    [string]$WinGetPackageId  # WinGet package ID (null for parent, package ID for children)
    [string]$Arguments  # Command-line arguments for file execution or WinGet installation
    [string[]]$VerifyServices  # Services to verify after installation
    [int]$ServiceWaitTime  # Custom wait time for this file (0 = use default)

    TreeNode([string]$name, [string]$url, [bool]$isDir, [TreeNode]$parent, [int]$level) {
        $this.Name = $name
        $this.Url = $url
        $this.IsDirectory = $isDir
        $this.IsExpanded = $false
        $this.IsSelected = $false
        $this.Children = @()
        $this.Parent = $parent
        $this.Level = $level
        $this.LocalPath = $null
        $this.IsVirtualWinGet = $false
        $this.WinGetPackageId = $null
        $this.Arguments = $null
        $this.VerifyServices = @()
        $this.ServiceWaitTime = 0
    }
}
