function Get-TreePrefix {
    <#
    .SYNOPSIS
        Generates the tree structure prefix for a node
    .DESCRIPTION
        Builds the visual tree prefix (lines and branches) based on the node's position in the hierarchy
    .PARAMETER Node
        The TreeNode to generate prefix for
    .PARAMETER IsLast
        Whether this node is the last sibling in its parent's children
    .OUTPUTS
        String containing the tree structure prefix
    #>
    param(
        [TreeNode]$Node,
        [bool]$IsLast
    )

    $prefix = ""
    $currentNode = $Node.Parent
    $levels = @()

    # Build the tree structure going up
    while ($currentNode -ne $null -and $currentNode.Parent -ne $null) {
        $siblings = $currentNode.Parent.Children
        $isLastSibling = ($siblings[-1] -eq $currentNode)
        $levels = @($isLastSibling) + $levels
        $currentNode = $currentNode.Parent
    }

    # Draw the prefix
    foreach ($isLastInLevel in $levels) {
        if ($isLastInLevel) {
            $prefix += $script:symbols.Space
        } else {
            $prefix += $script:symbols.Vertical
        }
    }

    # Add the branch connector
    if ($Node.Parent -ne $null -and $Node.Level -gt 0) {
        if ($IsLast) {
            $prefix += $script:symbols.LastBranch
        } else {
            $prefix += $script:symbols.Branch
        }
    }

    return $prefix
}
