function Get-FlattenedNodes {
    <#
    .SYNOPSIS
        Recursively flattens the tree into a linear list
    .DESCRIPTION
        Internal helper that recursively traverses the tree and builds a flat list
        of visible nodes (respecting expansion state)
    #>
    param([TreeNode]$Node, [ref]$List)

    $List.Value += $Node

    if ($Node.IsDirectory -and $Node.IsExpanded -and $Node.Children.Count -gt 0) {
        foreach ($child in $Node.Children) {
            Get-FlattenedNodes -Node $child -List $List
        }
    }
}

function Update-FlattenedList {
    <#
    .SYNOPSIS
        Updates the flattened node list based on current tree state
    .DESCRIPTION
        Rebuilds the flat list of visible nodes. Call this whenever the tree structure
        changes (expand, collapse, add nodes, etc.)
    .PARAMETER Root
        The root TreeNode of the tree
    #>
    param([TreeNode]$Root)

    $script:flattenedNodes = @()
    $list = New-Object System.Collections.ArrayList
    Get-FlattenedNodes -Node $Root -List ([ref]$list)
    $script:flattenedNodes = @($list)
}
