@{
    # Module metadata
    ModuleVersion = '1.0.0'
    GUID = 'a1b2c3d4-e5f6-4a5b-8c9d-0e1f2a3b4c5d'
    Author = 'Farm Town Tech'
    CompanyName = 'Farm Town Tech'
    Copyright = '(c) 2025 Farm Town Tech. All rights reserved.'
    Description = 'Interactive tree-based UI component for PowerShell console applications with selective redrawing and keyboard navigation.'

    # Module requirements
    PowerShellVersion = '5.1'

    # Root module
    RootModule = 'ITM.TreeUI.psm1'

    # Functions to export
    FunctionsToExport = @(
        'Draw-Tree'
        'Update-FlattenedList'
        'Get-TreePrefix'
    )

    # Variables to export
    VariablesToExport = @(
        'currentIndex'
        'flattenedNodes'
        'scrollOffset'
    )

    # Cmdlets to export
    CmdletsToExport = @()

    # Aliases to export
    AliasesToExport = @()

    # Private data
    PrivateData = @{
        PSData = @{
            Tags = @('UI', 'Tree', 'Console', 'Interactive', 'Menu')
            ProjectUri = 'https://github.com/derenzyit/ITM'
            ReleaseNotes = @'
Version 1.0.0
- Initial modular release
- Extracted from monolithic ITM.ps1
- Performance optimized rendering with StringBuilder
- Selective redrawing for minimal screen updates
- Support for dark/light themes
'@
        }
    }
}
